' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

''' <summary>
''' Reprezentuje zamwiony produkt, umieszczony w koszyku.
''' </summary>
Public Class OrderedProduct

#Region "Zmienne prywatne"
  Private _id As Guid = Guid.NewGuid
  Private _theProduct As Product
  Private _quantity As Integer
#End Region

#Region "Konstruktor(y)"

  ''' <summary>
  ''' Domylny konstruktor klasy OrderedProduct.
  ''' </summary>
  Public Sub New()
    ' Utwrz domylny produkt. Uywane przy wizaniu z danymi / edycji koszyka
    _theProduct = New Product
  End Sub

  ''' <summary>
  ''' Przeadowany konstruktor przyjmujcy wewntrzny produkt i pocztkow ilo.
  ''' </summary>
  ''' <param name="theProduct">Wewntrzny obiekt Product uywany w tym obiekcie OrderedProduct./</param>
  ''' <param name="quantity">Zamwiona liczba produktw.</param>
  Public Sub New(ByVal theProduct As Product, ByVal quantity As Integer)
    _theProduct = theProduct
    _quantity = quantity
  End Sub
#End Region

#Region "Waciwoci publiczne"

  ''' <summary>
  ''' Unikalny identyfikator obiektu OrderedProduct.
  ''' </summary>
  Public Property Id() As Guid
    Get
      Return _id
    End Get
    Set(ByVal value As Guid)
      _id = value
    End Set
  End Property


  ''' <summary>
  ''' Identyfikator wewntrznego obiektu Product.
  ''' </summary>
  Public ReadOnly Property ProductId() As Integer
    Get
      Return _theProduct.Id
    End Get
    '  Set(ByVal value As Integer)
    '    _theProduct.Id = value
    '  End Set
  End Property

  ''' <summary>
  ''' Opis wewntrznego obiektu Product.
  ''' </summary>
  Public ReadOnly Property Description() As String
    Get
      Return _theProduct.Description
    End Get
  End Property

  ''' <summary>
  ''' Tytu wewntrznego obiektu Product.
  ''' </summary>
  Public Property Title() As String
    Get
      Return _theProduct.Title
    End Get
    Set(ByVal value As String)
      _theProduct.Title = value
    End Set
  End Property

  ''' <summary>
  ''' Url maego obrazka wewntrznego Produktu.
  ''' </summary>
  Public Property PictureUrlSmall() As String
    Get
      Return _theProduct.PictureUrlSmall
    End Get
    Set(ByVal value As String)
    End Set
  End Property


  ''' <summary>
  ''' Cena wewntrznego produktu.
  ''' </summary>
  Public Property Price() As Decimal
    Get
      Return _theProduct.Price
    End Get
    Set(ByVal value As Decimal)
    End Set
  End Property


  ''' <summary>
  ''' Identyfikator kategorii wewntrznego produktu.
  ''' </summary>
  Public ReadOnly Property CategoryId() As Integer
    Get
      Return _theProduct.CategoryId
    End Get
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia liczb zamwionych towarw.
  ''' </summary>
  Public Property Quantity() As Integer
    Get
      Return _quantity
    End Get
    Set(ByVal value As Integer)
      _quantity = value
    End Set
  End Property

  ''' <summary>
  ''' Zwraca sum czciow produktu mnoc <see cref="Price" /> i <see cref="Quantity"/>.
  ''' </summary>
  Public Property SubTotal() As Decimal
    Get
      Return _theProduct.Price * _quantity
    End Get
    Set(ByVal value As Decimal)

    End Set
  End Property

#End Region

End Class
